" Install vim-plug (from vim bootstrap)
let vimplug_exists=expand('~/.config/nvim/autoload/plug.vim')

if !filereadable(vimplug_exists)
  echo "Installing Vim-Plug..."
  echo ""
  silent !\curl -fLo ~/.config/nvim/autoload/plug.vim --create-dirs https://raw.githubusercontent.com/junegunn/vim-plug/master/plug.vim
  let g:not_finish_vimplug = "yes"

  autocmd VimEnter * PlugInstall
endif


" plugins
call plug#begin('~/.vim/plugged')
    Plug 'scrooloose/nerdtree'
    Plug 'tpope/vim-commentary'
    Plug 'tpope/vim-fugitive'
    Plug 'ctrlpvim/ctrlp.vim'
    Plug 'vim-airline/vim-airline'
    Plug 'vim-airline/vim-airline-themes'
    Plug 'airblade/vim-gitgutter'
    Plug 'bronson/vim-trailing-whitespace'

    Plug 'Xuyuanp/nerdtree-git-plugin'

    Plug 'rhysd/vim-crystal'
    Plug 'fatih/vim-go'
    Plug 'chriskempson/base16-vim'
    Plug 'altercation/vim-colors-solarized'
    Plug 'morhetz/gruvbox'
    Plug 'sonph/onehalf', {'rtp': 'vim/'}
    Plug 'arcticicestudio/nord-vim'

    " Plug 'ensime/ensime-vim'

    Plug 'majutsushi/tagbar'
    " Plug 'scrooloose/syntastic'
    Plug 'vim-scripts/grep.vim'
    Plug 'AndrewRadev/splitjoin.vim'
    Plug 'inkarkat/vim-ingo-library'
    Plug 'vim-scripts/QuickFixCurrentNumber'

    " Gonvim
    Plug 'dzhou121/gonvim-fuzzy'       " Vim plug
    Plug 'equalsraf/neovim-gui-shim'       " Vim plug

    " Language server
    Plug 'autozimu/LanguageClient-neovim', {
    \ 'branch': 'next',
    \ 'do': 'bash install.sh',
    \ }

    " (Optional) Multi-entry selection UI.
    Plug 'junegunn/fzf'

    if has('nvim')
      Plug 'Shougo/deoplete.nvim', { 'do': ':UpdateRemotePlugins' }
    else
      Plug 'Shougo/deoplete.nvim'
      Plug 'roxma/nvim-yarp'
      Plug 'roxma/vim-hug-neovim-rpc'
    endif
    Plug 'zchee/deoplete-go', { 'do': 'make'}
    Plug 'zchee/deoplete-jedi'                     " Go auto completion
    " Plug 'uplus/deoplete-solargraph'               " Ruby auto completion
    Plug 'neomake/neomake'

    " Icons
    Plug 'ryanoasis/vim-devicons'

    " helm
    Plug 'towolf/vim-helm'
call plug#end()


" reload configuration when saved
augroup myvimrchooks
    au!
    autocmd bufwritepost init.vim source $MYVIMRC
augroup END




" *****************************
" Bootstrap conf
" *****************************
"
set nocompatible
" set modeline

"" Encoding
set encoding=utf-8
set fileencoding=utf-8
set fileencodings=utf-8

" set term=xterm-256color

"" Searching
set hlsearch
set incsearch
set ignorecase
set smartcase

"" Encoding
set bomb
set binary
set ttyfast

"" Directories for swp files
set nobackup
set noswapfile

set fileformats=unix,dos,mac
set showcmd
set shell=/bin/sh

"" no one is really happy until you have this shortcuts
cnoreabbrev W! w!
cnoreabbrev Q! q!
cnoreabbrev Qall! qall!
cnoreabbrev Wq wq
cnoreabbrev Wa wa
cnoreabbrev wQ wq
cnoreabbrev WQ wq
cnoreabbrev W w
cnoreabbrev Q q
cnoreabbrev Qall qall


"" Map leader to ,
let mapleader=','

" Enable ctrlp caching
let g:ctrlp_use_caching = 1

" change paste mode with F10 (even in insert mode
set pastetoggle=<F10>

" disable line highlight as it very slow
set nocursorline

" enable spell checking
set spell spelllang=en_us

"" Tabs (vim bootstrap)
nnoremap <Tab> gt
nnoremap <S-Tab> gT
nnoremap <silent> <S-t> :tabnew<CR>

" vim-airline (vim bootstrap)
let g:airline_powerline_fonts = 0
" let g:airline_theme = 'powerlineish'
let g:airline_theme = 'onehalfdark'
let g:airline#extensions#syntastic#enabled = 1
let g:airline#extensions#branch#enabled = 1
let g:airline#extensions#tabline#enabled = 1
let g:airline#extensions#tagbar#enabled = 1

" NerdTree (vim bootstrap)
noremap <F3> :NERDTreeToggle<CR>

" Tagbar
nmap <silent> <F4> :TagbarToggle<CR>
let g:tagbar_autofocus = 1

"" Git (vim bootstrap)
noremap <Leader>ga :Gwrite<CR>
noremap <Leader>gc :Gcommit<CR>
noremap <Leader>gsh :Gpush<CR>
noremap <Leader>gll :Gpull<CR>
noremap <Leader>gs :Gstatus<CR>
noremap <Leader>gb :Gblame<CR>
noremap <Leader>gd :Gvdiff<CR>
noremap <Leader>gr :Gremove<CR>

" Ensime
noremap <Leader>sb :EnDocBrowse<CR>
noremap <Leader>sd :EnDeclaration<CR>
noremap <Leader>ss :EnDeclarationSplit<CR>

"" Copy/Paste/Cut (vim bootstrap)
if has('unnamedplus')
  set clipboard=unnamed,unnamedplus
endif

noremap YY "+y<CR>
noremap <leader>p "+gP<CR>
noremap XX "+x<CR>

" To test. From http://superuser.com/questions/10588/how-to-make-cut-copy-paste-in-gvim-on-ubuntu-work-with-ctrlx-ctrlc-ctrlv/189198#189198
vmap <C-c> "+yi
vmap <C-x> "+c
vmap <C-v> c<ESC>"+p
imap <C-v> <C-r><C-o>+

"" ctrlp.vim (vim bootstrap)
set wildmode=list:longest,list:full
set wildignore+=*.o,*.obj,.git,*.rbc,*.pyc,__pycache__
let g:ctrlp_custom_ignore = '\v[\/](node_modules|target|dist|vendor)|(\.(swp|tox|ico|git|hg|svn))$'
let g:ctrlp_user_command = "find %s -type f | grep -Ev '"+ g:ctrlp_custom_ignore +"'"
let g:ctrlp_use_caching = 0
cnoremap <C-P> <C-R>=expand("%:p:h") . "/" <CR>
noremap <leader>b :CtrlPBuffer<CR>
let g:ctrlp_map = '<leader>e'
let g:ctrlp_open_new_file = 'r'


"" Buffer nav
noremap <leader>z :bp<CR>
noremap <leader>q :bp<CR>
noremap <leader>x :bn<CR>
noremap <leader>w :bn<CR>

"" Close buffer
noremap <leader>c :bd<CR>

"" Clean search (highlight)
nnoremap <silent> <leader><space> :noh<cr>

"" Vmap for maintain Visual Mode after shifting > and <
vmap < <gv
vmap > >gv


"" Move visual block
vnoremap J :m '>+1<CR>gv=gv
vnoremap K :m '<-2<CR>gv=gv

" Move to other splits (also for terminal buffers)
" :tnoremap <A-h> <C-\><C-n><C-w>h
" :tnoremap <A-j> <C-\><C-n><C-w>j
" :tnoremap <A-k> <C-\><C-n><C-w>k
" :tnoremap <A-l> <C-\><C-n><C-w>l
" :nnoremap <A-h> <C-w>h
" :nnoremap <A-j> <C-w>j
" :nnoremap <A-k> <C-w>k
" :nnoremap <A-l> <C-w>l
" 
" :tnoremap <A-Left> <C-\><C-n><C-w>Left
" :tnoremap <A-Down> <C-\><C-n><C-w>Down
" :tnoremap <A-Up> <C-\><C-n><C-w>Up
" :tnoremap <A-Right> <C-\><C-n><C-w>Right
" :nnoremap <A-Left> <C-w>Left
" :nnoremap <A-Down> <C-w>Down
" :nnoremap <A-Up> <C-w>Up
" :nnoremap <A-Right> <C-w>Right

" UI
" set background=dark
let base16colorspace=256
colorscheme base16-flat
" colorscheme solarized
" colorscheme gruvbox
" colorscheme onehalfdark
set cc=80
set termguicolors

" hide grey bar for splits
" set fillchars=""
set fillchars+=vert:│
hi VertSplit ctermbg=NONE guibg=NONE

set linebreak
set nonumber

set modeline

" Indentation
set tabstop=2
set sw=2
set et
set ai


augroup vimrc-yaml
  autocmd!
  autocmd BufNewFile,BufRead *.yml,*.yaml setlocal filetype=yaml
  autocmd FileType yaml set tabstop=2|set shiftwidth=2|set expandtab
augroup END

augroup vimrc-go
  autocmd!
  au BufNewFile,BufRead *.go setlocal noet ts=4 sw=4 sts=4
augroup END

" scala
" autocmd BufWritePost *.scala silent :EnTypeCheck
" nnoremap <leader>t :EnType<CR>
function! SyntasticDisableBuffer()
    let b:syntastic_skip_checks = 1
    SyntasticReset
    echo 'Syntastic disabled for this buffer'
endfunction

augroup vimrc-scala
  autocmd!
  autocmd FileType scala call SyntasticDisableBuffer()
  autocmd BufWritePost *.scala silent :EnTypeCheck
augroup END

" Syntastic

let g:syntastic_always_populate_loc_list=1
let g:syntastic_error_symbol='✗'
let g:syntastic_warning_symbol='⚠'
let g:syntastic_style_error_symbol = '✗'
let g:syntastic_style_warning_symbol = '⚠'
let g:syntastic_auto_loc_list=1
let g:syntastic_aggregate_errors = 1

let g:syntastic_go_checkers = ['golint', 'govet']
let g:syntastic_mode_map = { 'mode': 'active', 'passive_filetypes': ['go'] }

" grep.vim
nnoremap <silent> <leader>f :Rgrep<CR>
let Grep_Default_Options = '-IR'
let Grep_Skip_Files = '*.log *.db'
let Grep_Skip_Dirs = '.git node_modules'

" In the quickfix window, <CR> is used to jump to the error under the
" cursor, so undefine the mapping there.
autocmd BufReadPost quickfix nnoremap <buffer> <CR> <CR>

" Go
set autowrite
let g:go_list_type = "quickfix"
let g:go_test_timeout = '10s'
" let g:go_auto_type_info = 1
set updatetime=100
" let g:go_metalinter_autosave = 1
let g:go_jump_to_error = 1
let g:go_echo_command_info = 0
let g:go_fmt_command = "goimports"

let g:go_highlight_extra_types = 1
let g:go_highlight_operators = 1
let g:go_highlight_functions = 1
let g:go_highlight_function_arguments = 1
let g:go_highlight_function_calls = 1
let g:go_highlight_types = 1
let g:go_highlight_fields = 1
let g:go_highlight_variable_declarations = 1
let g:go_highlight_variable_assignments = 1



map <C-b> :cc<CR>
map <C-n> :cnext<CR>
map <C-m> :cprevious<CR>
nnoremap <leader>a :cclose<CR>

" autocmd FileType go nmap <leader>b  <Plug>(go-build)
autocmd FileType go nmap <leader>or  <Plug>(go-run)
autocmd FileType go nmap <leader>ot  <Plug>(go-test)
autocmd FileType go nmap <Leader>oc  <Plug>(go-coverage-toggle)
autocmd FileType go nmap <Leader>oi  <Plug>(go-info)
autocmd FileType go nmap <Leader>oe  <Plug>(go-iferr)

" run :GoBuild or :GoTestCompile based on the go file
function! s:build_go_files()
  let l:file = expand('%')
  if l:file =~# '^\f\+_test\.go$'
    call go#test#Test(0, 1)
  elseif l:file =~# '^\f\+\.go$'
    call go#cmd#Build(0)
  endif
endfunction

autocmd FileType go nmap <leader>ob :<C-u>call <SID>build_go_files()<CR>

"----------------------------------------------
" Plugin: Shougo/deoplete.nvim
"----------------------------------------------
" if has('nvim')
    " Enable deoplete on startup
    let g:deoplete#enable_at_startup = 1
" endif

" Disable deoplete when in multi cursor mode
function! Multiple_cursors_before()
    let b:deoplete_disable_auto_complete = 1
endfunction

function! Multiple_cursors_after()
    let b:deoplete_disable_auto_complete = 0
endfunction

" " When writing a buffer.
" call neomake#configure#automake('w')
" " When writing a buffer, and on normal mode changes (after 750ms).
call neomake#configure#automake('nw', 750)
" When reading a buffer (after 1s), and when writing.
" call neomake#configure#automake('rw', 1000)

" neomake
autocmd BufWritePost * Neomake
let g:neomake_error_sign   = {'text': '✖', 'texthl': 'NeomakeErrorSign'}
let g:neomake_warning_sign = {'text': '∆', 'texthl': 'NeomakeWarningSign'}
let g:neomake_message_sign = {'text': '➤', 'texthl': 'NeomakeMessageSign'}
let g:neomake_info_sign    = {'text': 'ℹ', 'texthl': 'NeomakeInfoSign'}
let g:neomake_go_enabled_makers = [ 'go', 'gometalinter' ]
let g:neomake_go_gometalinter_maker = {
  \ 'args': [
  \   '--tests',
  \   '--enable-gc',
  \   '--concurrency=3',
  \   '--fast',
  \   '-D', 'aligncheck',
  \   '-D', 'dupl',
  \   '-D', 'gocyclo',
  \   '-D', 'gotype',
  \   '-E', 'errcheck',
  \   '-E', 'misspell',
  \   '-E', 'unused',
  \   '%:p:h',
  \ ],
  \ 'append_file': 0,
  \ 'errorformat':
  \   '%E%f:%l:%c:%trror: %m,' .
  \   '%W%f:%l:%c:%tarning: %m,' .
  \   '%E%f:%l::%trror: %m,' .
  \   '%W%f:%l::%tarning: %m'
  \ }

" Gonvim
let g:gonvim_draw_statusline = 1

" Dismiss deoplete popup with enter
" inoremap <expr> <CR> (pumvisible() ? "\<c-y>\<cr>" : "\<CR>")

" Language server
"
" Required for operations modifying multiple buffers like rename.
set hidden

let g:LanguageClient_serverCommands = {
    \ 'crystal': ['scry'],
    \ }
    " \ 'rust': ['rustup', 'run', 'nightly', 'rls'],
    " \ 'javascript': ['javascript-typescript-stdio'],
    " \ 'javascript.jsx': ['tcp://127.0.0.1:2089'],
    " \ 'python': ['pyls'],
    " \ }

nnoremap <F5> :call LanguageClient_contextMenu()<CR>
" Or map each action separately
nnoremap <silent> K :call LanguageClient#textDocument_hover()<CR>
nnoremap <silent> gd :call LanguageClient#textDocument_definition()<CR>
nnoremap <silent> <F2> :call LanguageClient#textDocument_rename()<CR>
